//******************************************
// file			: main.c
// version		: V1.0
// brief		: main program
// note			: When the TCQ04 starts and the counter value is the same as T04REG, the TCQ00 interrupt occurs.
//				  At this point, P82 output level is inverted. 
//				  When the TCQ05 starts and the counter value is the same as T05REG, the TCQ01 interrupt occurs.
//				  At this point, P83 output level is inverted.
//****************************************** 
//******************************************
//Stack Pointer	=	0x23f (If use mq6822_x_startup.asm)
//Ram range = 0x40~0x23f
//******************************************
#ifndef	IO_MEM
#define	IO_MEM
#endif  
#include "MQ6822.h"
 


void main()
{
//============================================
// setting and start TCQ04
//============================================
    P8CR.bit.b2	=1;			//set P82 output
 	__asm("DI");	
	POFFCR0.bit.b6=1; 		//[-.TC045EN,TC023EN,TC001EN	-,-,-,TCA0EN]
							//enable TC04 and TC05
	EIRD.bit.b4=1; 			//[-,-,INTTC05,INTTC04	-,-,INTTC03,INTTC02]
							//enable TC04 interrupt
	__asm("EI");
	T04MOD.byte=0xF8;		//[TFF,DBE,TCK[3],-,TCM]
							//<DBE>=1,<TCK>=111,<TCM>=0 10-bit timer mode
	T04REGL.byte=0x5; 		//set timer value
	T04REGH.byte=0x1; 		//set timer value = 0x0105
	T045CR.bit.b0=1; 		//[-,-,-,COMPSL	  OUTAND,-,T05RUN,T04RUN]
							//start TCQ04   
	
//============================================
// setting and start TCQ05
//============================================
    P8CR.bit.b3	=1;			//set P83 output
 	__asm("DI");	
	POFFCR0.bit.b6=1;		//[-.TC045EN,TC023EN,TC001EN	-,-,-,TCA0EN]
							//enable TC00 and TC01 
	EIRD.bit.b5=1; 			//[-,-,INTTC05,INTTC04	-,-,INTTC03,INTTC02]
							//enable TC05 interrupt
	__asm("EI");
	T05MOD.byte=0xF8;		//[TFF,-,TCK[3],-,TCM]
							//<TCK>=111,<TCM>=0 10-bit timer mode
	T05REGL.byte=0x5; 		//set timer value
	T05REGH.byte=0x1; 		//set timer value = 0x0105
	T045CR.bit.b1=1; 		//[-,-,-,COMPSL	  OUTAND,-,T05RUN,T04RUN]
							//start TCQ05   	

    while(1)
	{
		WDCDR.byte= 0x4e;	//clear wdt
	}  
	
}